----------------
title : C++ 레퍼런스 - ifstream 생성자
cat_title : ifstream 생성자
ref_title : ifstream::ifstream
publish_date : 2019-04-28
path : /C++ Reference/iostream
--------------

##@ cpp-ref-start

#@ ifstream 생성자

```cpp-formatted
basic_ifstream();  // (1)
explicit basic_ifstream(const char* filename,
                        std::ios_base::openmode mode = ios_base::in);  // (2)

explicit basic_ifstream(const std::filesystem::path::value_type* filename,
                        std::ios_base::openmode mode = ios_base::in);  // (3)

explicit basic_ifstream(const std::string& filename,
                        std::ios_base::openmode mode = ios_base::in);  // (4)

explicit basic_ifstream(const std::filesystem::path& filename,
                        std::ios_base::openmode mode = ios_base::in);  // (5)

basic_ifstream(basic_ifstream&& other);  // (6)

basic_ifstream(const basic_ifstream& rhs) = delete;
```

새로운 파일 스트림을 생성한다.

참고로 `ifstream` 은 `basic_ifstream<char>` 과 같다. `basic_ifstream<wchar_t>` 의 경우 `wifstream` 이다.

1. 기본 생성자 : 어떤 파일과도 연관되어 있지 않는 스트림을 생성한다.
2. 스트림을 생성한 후에, `rdbuf()->open(filename, mod | std::ios_base::in)` 을 통해서 파일과 스트림을 연관시킨다. 만일 `open` 함수가 널 포인터를 리턴하게 된다면 `failbit` 을 설정한다.
3. 위와 비슷하지만, 이 경우 `std::filesystem::path::value_type` 이 `char` 가 아닐 때 오버로딩 된다.
4. `basic_ifstream(filename.c_str(), mode)` 를 호출한 것과 동일
5. `basic_ifstream(filename.c_str(), mode)` 를 호출한 것과 동일
6. 이동 생성자

### 인자들

* `filename` : 열 파일 이름
* `mode` : 어떠한 방식으로 스트림을 열 것이지 지정한다. 아래와 같은 상수들이 정의되어 있다.

|상수|설명|
|---|---|
|`app`|항상 스트림에 끝에 쓴다|
|`binary`|이진 형태로 파일을 읽는다|
|`in`|읽기 작업을 위해 파일을 연다|
|`out`|쓰기 작업을 위해 파일을 연다|
|`trunc`|파일을 열면서 스트림에 쓰여진 내용들을 모두 지운다|
|`ate`|파일을 열음과 동시에 스트림의 끝으로 이동한다|

* `other` : 다른 파일 스트림

### 실행 예제

```cpp-formatted
#include <fstream>
#include <string>
#include <utility>
int main() {
  std::ifstream f0;
  std::ifstream f1("test.bin", std::ios::binary);
  std::string name = "example.txt";
  std::ifstream f2(name);
  std::ifstream f3(std::move(f1));
}
```

### 참고 자료

* `open` : 파일을 연 다음, 스트림과 연관 시킨다.